binsROC <- function (X, D, meth = c("L", "S"), grid, ci, cl, ci_meth = c("E", "V", "B"), nboost){

  Check_Marker_Response <- function (Y, X){
    mt <- NULL
    # Response data
    if (missing(Y) | is.null(Y) | sum(!is.na(Y))== 0){
      m <- "Response data should be indicated."
      stop(m)
    } else{
      level <- (levels(as.factor(Y)))
      l <- length(level)
      if (l < 2){
        m <- "Response data must contain at least two different values."
        stop(m)
      } else if (l > 2){
        m <- "There are more than two different values in response data.
        Only the two lowest will be considered."
        mt <- rbind(mt, c("Y", m))
        # warning(m)
      }
    }
    # Biomarker
    if (missing(X) | is.null(X) | sum(!is.na(X))== 0){
      m <- "Marker data should be indicated."
      stop(m)
    } else if(!is.numeric(X)){
      m <- "Marker data are not numeric."
      stop(m)
    }

    # Response & Biomarker data
    if(length(Y) != length(X)){
      m <- "Response and marker vectors should have the same length."
      stop(m)
    }
    # Missing biomarker values
    Im <- which(!is.na(X))
    X  <- X[Im]
    Y  <- Y[Im]
    m <- "Observations with missing Marker values have been removed."
    # warning(m)
    mt <- rbind (mt, c("X",m))

    # Missing response values
    neg <- split(X, Y)[[level[1]]]
    pos <- split(X, Y)[[level[2]]]
    Ims <- which(is.na(Y))
    n0 <- length(neg)
    n1 <- length(pos)
    nm <- length(Ims)
    l0 <- ifelse (level[1] == 0, level[1],0)
    l1 <- ifelse (level[2] == 1, level[2],1)
    X_bm <- c(neg, pos)
    Y_bm <- c(rep(l0, n0), rep(l1, n1))
    X <- c(X_bm, X[Ims])
    Y <- c(Y_bm, Y[Ims])

    list(X = as.numeric(X), Y = as.numeric(Y), X_bm = as.numeric(X_bm), Y_bm = as.numeric(Y_bm),
         controls = n0, cases = n1, mis = nm, mt = mt)
  }
  # Grid - grid
  Check_grid <- function(grid){
    mt <- NULL
    if (missing(grid)){
      grid <- 1000
      m <- "No grid indicated. 1000 grid is assumed."
      # warning(m)
      mt <- rbind(mt, c("grid", m))
    } else if (!((is.numeric(grid)) | grid > 0)){
      m <- paste(grid, "-", "Invalid grid selection. ")
      stop(m)
    }
    list(grid = as.numeric(grid), mt = mt)
  }
  # Confidence Intervals - ci
  Check_ci <- function(ci, cl, ci_meth, nboost){
    # Nº bootstrap - nboost
    Check_nboost <- function(nboost){
      mt <- NULL
      if (missing(nboost)){
        nboost <- 500
        m <- "500 boostrap samples will be computed."
        mt <- rbind(mt, c("nboost", m))
      } else if(!(is.numeric(nboost) | nboost > 0)){
        m <- "Invalid nboost selection."
        stop(m)
      }
      list(nboost = as.numeric(nboost), mt = mt)
    }

    mt <- NULL
    if (missing(ci)){
      ci <- FALSE
    } else if (!((is.logical(ci)))){
      m <- paste(ci, "-", "Invalid ci selection. ")
      stop(m)
    }

    # Confidence Level - cl
    if(missing(cl)){
      cl <- 0.95
      if (ci){
        m <- "Confidence Intervals will be computed at 0.95 confidence level."
        mt <- rbind(mt, c("cl",m))
      }
    } else if(!(is.numeric(cl))){
      m <- paste(cl, "-", "Should be a numerical value between 0 and 1.")
      stop(m)
    } else if(!( (0 <= cl) & (cl <= 1))){
      m <- "Invalid confidence level."
      stop(m)
    }

    # Boostrap samples - nboost
    nboost <- Check_nboost(nboost)
    if(!ci){
      cl <- NULL
      ci_meth <- NULL
      nboost  <- NULL
    }
    # Confidence intervals & confidence level & methods for computing ci
    if(!ci){
      if(!(is.null(cl)) & is.null(ci_meth)){
        m <- "No Confidence Intervals will be computed with indicated method/confidence level."
        mt <- rbind(mt, c("ci",m))
      }
    }
    list(ci = ci, cl = cl, ci_meth = ci_meth, nboost = nboost)
  }

  f_ROC <- function(Y, X, R, meth, grid){
      l <- 1/grid
              if (meth == "L"){
                  mod <- glm(Y ~ X, family = binomial)
              }else{
                  mod <- glm(Y ~ rcs(X), family = binomial)
              }
              fuT <- approxfun(X,as.numeric(-predict(mod)))(R)
              P   <- as.numeric(1 / (1 + exp(fuT)))
              P   <- P[order(R)]

          # Sensitivity, Specificity
              SP <- cumsum(1-P)/sum(1-P)
              SE <- 1-cumsum(P)/sum(P)
          # ROC curve
              u  <- seq(0,1,l)
              fuR <- approxfun(1-SP, SE)(u)
              ROC <- ifelse(is.na(fuR), 1, fuR)
          # AUC
              auc <- sum(ROC) * l
              ret <- list(Y = Y, X = X, P = P, SE = SE, SP = SP, u = u, ROC = ROC, auc = auc)
    }

  #  Check data
     data         <- Check_Marker_Response (Y = D, X = X)
     data$meth    <- match.arg(meth)
     data_grid    <- Check_grid(grid)
     data$grid    <- as.numeric(data_grid$grid)
     data$ci_meth <- match.arg(ci_meth)
     data_ci      <- Check_ci(ci = ci, cl = cl, ci_meth = data$ci_meth, nboost = nboost)

     if(!is.null(data_grid$mt)){
        data$mt <- rbind(data$mt, data_grid$mt)
     }
     if(!is.null(data_ci$mt)){
        data$mt <- rbind(data$mt, data_ci$mt)
     }

  #  ROC Curve
     ROCb <- f_ROC(Y = data$Y_bm, X = data$X_bm, R = data$X, meth = data$meth, grid = data$grid)

  #  Confidence Intervals for the AUC
     if (data_ci$ci){
           cl   <- (1 - data_ci$cl) / 2
           if(data_ci$ci_meth == "E"){
               nint <- function(a,b){int = 0
                                     for (i in 2:length(a)) {int = int + (a[i]- a[i-1])*b[i-1]}
                                     return(int)}
               pi   <- mean(ROCb$P)
               va   <- (nint(ROCb$SP,ROCb$SE^2) - nint(ROCb$SP,ROCb$SE)^2 +
                       ((1-pi)/pi)*(nint(1-ROCb$SE,ROCb$SP^2) -
                       nint(1-ROCb$SE,ROCb$SP)^2))^0.5 / sqrt((data$controls + data$cases) * (1-pi))
               ic_l <- round(ROCb$auc + qnorm(cl) * va, 5)
               ic_u <- round(ROCb$auc - min(qnorm(cl)*va,1), 5)
           } else if(data_ci$ci_meth == "B"){
               nbst <- as.numeric(data_ci$nboost[1])
               vauc <- c(1:nbst)
               for (b in 1:nbst){
                       n  <- data$controls + data$cases
                       Ib <- base::sample(c(1:n), n, replace = TRUE)
                       vauc[b] <- f_ROC(data$Y_bm[Ib], data$X_bm[Ib], meth = data$meth,
                                        grid = as.numeric(data$grid[1]))$auc
               }
               vauc <- sort(vauc)
               ic_l <- round(vauc[nbst * cl], 5)
               ic_u <- round(vauc[nbst * (1 - cl)],5)
           } else {
               Variance_Pi <- function( Y, X, meth= c("L","S"), grid, nboost){
                    sdMatrix= matrix(-1,ncol=grid + 1, nboost)
                    dt= cbind(Y,X)
                    colSD<- function(M){
                        n= ncol(M)
                        nSD= 1:n
                        for (j in 1:n) nSD[j]= sd(M[,j], na.rm=TRUE)
                        return(nSD)
                    }
                    for (b in 1:nboost) {
                        ixB <- sample(1:length(dt[,2]), replace=TRUE)
                        dtB <- dt[ixB,]
                        if (meth == "L") {
                            mdB <- glm(dtB[order(dtB[,2]),1] ~ sort(dtB[,2]), family=binomial)
                        } else {
                            mdB <- glm(dtB[order(dtB[,2]),1] ~ rcs(sort(dtB[,2])), family=binomial)
                        }
                    PL <- as.numeric(1/(1+exp(-predict(mdB))))
                    sdMatrix[b, ] <- approxfun(c(0,sort(dtB[,2]),max(X)),c(0,PL,1))(0:grid)
                    print(b)
                    }
                    if (!is.null(sdMatrix)){return(colSD(sdMatrix))}
               }
               sdMatrix <- Variance_Pi(X = data$X_bm, Y=data$Y_bm, meth = meth, grid = 70, nboost = 2000)
               SDL <-  splinefun(0:70, sdMatrix)(sort(data$X_bm))
               pi <- mean(ROCb$P)

               E1 <- (1-pi)^-1*(ROCb$SE - ROCb$auc)*(1-ROCb$P)
               E2 <-  pi^-1*(ROCb$SP - ROCb$auc) * ROCb$P
               E3 <- (pi^-1*(ROCb$SP - ROCb$auc) - (1-pi)^-1*(ROCb$SE - ROCb$auc))*SDL

               vL   <- ( mean( (E1-E2)^2 ) + mean(E3)^2 )^0.5/sqrt(length(data$X_bm))
               ic_l <- ROCb$auc + qnorm(cl)*vL
               ic_u <- ROCb$auc  - min(qnorm(cl)*vL,1)
           }
      }else {
               ic_l <- NULL; ic_u <- NULL
      }
      if (!is.null(ROCb$SE)){
           ret = list(th = data$X_bm,  TP  = ROCb$SE,      FP = 1-ROCb$SP,   Pi = ROCb$P,
                       u = ROCb$u,     ROC = ROCb$ROC,     meth = data$meth, t  = NULL,
                       auc = ROCb$auc, ci = c(ic_l, ic_u), cl = data$cl,     ci_meth = data$ci_meth,
                       mt = data$mt)
           class(ret) <- "sMSROC";return(ret)
       } else{
           stop(message("Non results to be shown"))
       }
}



